<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCaseDeadlinesTable extends Migration {

	public function up()
	{
		Schema::create('case_deadlines', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('description');
			$table->string('notes');
			$table->date('deadline_date');
			$table->bigInteger('status_id')->unsigned();
			$table->bigInteger('case_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('case_deadlines');
	}
}