<?php

namespace App\Models\Subscription;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Subscription extends Eloquent {

	protected $table = 'subscriptions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('plan_id', 'user_id', 'amount_paid', 'start_date', 'end_date');

	public function palns()
	{
		return $this->belongsTo('Plans', 'plan_id');
	}

}