<?php

namespace App\Models\Task;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Task extends Eloquent {

	protected $table = 'tasks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('task_description', 'execution_date', 'task_status', 'assignee', 'employee_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

}