<?php

namespace App\Models\Case;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Case extends Eloquent {

	protected $table = 'cases';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function notification()
	{
		return $this->hasMany('CaseNotification');
	}

	public function deadline()
	{
		return $this->belongsTo('CaseDeadline');
	}

}