<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBatchesTable extends Migration {

	public function up()
	{
		Schema::create('batches', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('title')->nullable();
			$table->text('description')->nullable();
			$table->integer('index')->nullable();
			$table->boolean('is_active')->nullable()->default(true);
			$table->date('started_at')->nullable();
			$table->date('finished_at');
			$table->integer('promotion_id')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('batches');
	}
}