<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderMenusTable extends Migration {

	public function up()
	{
		Schema::create('order_menus', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->integer('order_id')->unsigned()->nullable()->index();
			$table->integer('order_item_id')->unsigned()->nullable()->index();
			$table->integer('batch_id')->unsigned()->nullable()->index();
			$table->integer('batch_menu_id')->unsigned()->nullable()->index();
			$table->integer('address_id')->unsigned()->nullable()->index();
			$table->boolean('utensil')->nullable()->default(false);
			$table->boolean('is_check')->default(false);
			$table->integer('check_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->boolean('is_printed')->nullable()->default(false);
			$table->boolean('is_ready')->nullable()->default(false);
			$table->integer('plating_by')->unsigned()->nullable()->index();
			$table->boolean('is_deliver')->nullable()->default(false);
			$table->text('full_note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_menus');
	}
}