<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('label')->nullable();
			$table->string('slug')->nullable();
			$table->string('group')->nullable();
			$table->string('value')->nullable();
			$table->string('rule_validations')->nullable();
			$table->string('type_value')->nullable();
			$table->text('description')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}