<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('number')->nullable();
			$table->integer('order_id')->unsigned()->nullable()->index();
			$table->integer('discount')->unsigned()->nullable();
			$table->timestamp('paid_at')->nullable();
			$table->string('proof_image_url')->nullable();
			$table->string('bank_name')->nullable();
			$table->string('bank_account_number')->nullable();
			$table->string('bank_account_name')->nullable();
			$table->string('package_order_type')->nullable();
			$table->integer('package_price')->nullable();
			$table->integer('pax')->nullable();
			$table->integer('service_fee')->nullable();
			$table->integer('delivery_fee')->nullable();
			$table->integer('total_discount')->nullable();
			$table->integer('total')->nullable();
			$table->string('customer_bank_name')->nullable();
			$table->string('customer_bank_account_number')->nullable();
			$table->string('customer_bank_account_name')->nullable();
			$table->text('remark')->nullable();
			$table->json('data')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->string('package_menu_category')->nullable();
			$table->integer('tax')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}