<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderReleasesTable extends Migration {

	public function up()
	{
		Schema::create('order_releases', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->integer('order_id')->unsigned()->nullable()->index();
			$table->integer('order_menu_id')->unsigned()->nullable()->index();
			$table->integer('driver_id')->unsigned()->nullable()->index();
			$table->text('notes')->nullable();
			$table->string('proof_image_url')->nullable();
			$table->smallInteger('status')->nullable();
			$table->timestamp('delivered_at')->nullable();
			$table->text('address')->nullable();
			$table->string('customer_name')->nullable();
			$table->string('customer_phone')->nullable();
			$table->boolean('is_confirm')->default(false);
			$table->integer('confirm_by')->unsigned()->nullable()->index();
			$table->integer('last_edit_by')->unsigned()->nullable()->index();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->date('batch_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order_releases');
	}
}