<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('number')->nullable();
			$table->integer('customer_id')->unsigned()->nullable()->index();
			$table->integer('customer_lead_id')->unsigned()->nullable()->index();
			$table->integer('order_type_id')->unsigned()->nullable()->index();
			$table->integer('menu_category_id')->unsigned()->nullable()->index();
			$table->integer('package_id')->unsigned()->nullable()->index();
			$table->json('data')->nullable();
			$table->text('description')->nullable();
			$table->integer('pax')->unsigned()->nullable();
			$table->date('started_at')->nullable();
			$table->date('finished_at')->nullable();
			$table->date('expired_at')->nullable();
			$table->smallInteger('status')->unsigned()->nullable()->index()->default('0');
			$table->integer('batch_start_id')->unsigned()->nullable()->index();
			$table->integer('batch_end_id')->unsigned()->nullable()->index();
			$table->integer('total')->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
			$table->integer('package_qouta')->nullable();
			$table->integer('total_order')->nullable();
			$table->integer('total_deliver');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}