<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagePromotionsTable extends Migration {

	public function up()
	{
		Schema::create('package_promotions', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->integer('package_id')->unsigned()->nullable()->index();
			$table->integer('promo_id')->unsigned()->nullable()->index();
			$table->boolean('is_active')->nullable()->default(false);
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('package_promotions');
	}
}