<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->unique();
			$table->string('name')->nullable();
			$table->string('email')->unique()->nullable();
			$table->string('plat_no')->nullable();
			$table->string('phone', 64)->unique()->nullable();
			$table->date('dob')->nullable();
			$table->char('gender', 1)->nullable();
			$table->integer('created_by')->unsigned()->nullable()->index();
			$table->integer('updated_by')->unsigned()->nullable()->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}