<?php

namespace App\Models\;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function roles()
	{
		return $this->hasMany('App\Models\\UserRole', 'user_id');
	}

	public function rights()
	{
		return $this->hasMany('UserRIght', 'user_id');
	}

	public function organization()
	{
		return $this->belongsTo('Organization', 'id_organization');
	}

}