<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fullname');
			$table->string('job_title');
			$table->string('mobile')->nullable();
			$table->integer('department_id')->unsigned();
			$table->date('dob');
			$table->date('hiring_date');
			$table->string('email')->nullable();
			$table->tinyInteger('gender');
			$table->string('address');
			$table->tinyInteger('marital_status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}