<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaterialsTable extends Migration {

	public function up()
	{
		Schema::create('materials', function(Blueprint $table) {
			$table->increments('id');
			$table->string('part_number');
			$table->tinyInteger('brand');
			$table->string('name');
			$table->integer('qty')->default('0');
			$table->longText('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('materials');
	}
}