<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('department')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('salaries', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supplier_bills', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supplier_bill_items', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supplier_bill_items', function(Blueprint $table) {
			$table->foreign('supplier_bill_id')->references('id')->on('supplier_bills')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_materials', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_materials', function(Blueprint $table) {
			$table->foreign('material_id')->references('id')->on('materials')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_group_id')->references('id')->on('user_groups')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('technical_proposals', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('proposal_items', function(Blueprint $table) {
			$table->foreign('technical_proposal_id')->references('id')->on('technical_proposals')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('proposal_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commercial_proposal', function(Blueprint $table) {
			$table->foreign('technical_proposal_id')->references('id')->on('technical_proposals')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('commercial_proposal_id')->references('id')->on('commercial_proposal')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_department_id_foreign');
		});
		Schema::table('salaries', function(Blueprint $table) {
			$table->dropForeign('salaries_employee_id_foreign');
		});
		Schema::table('supplier_bills', function(Blueprint $table) {
			$table->dropForeign('supplier_bills_supplier_id_foreign');
		});
		Schema::table('supplier_bill_items', function(Blueprint $table) {
			$table->dropForeign('supplier_bill_items_material_id_foreign');
		});
		Schema::table('supplier_bill_items', function(Blueprint $table) {
			$table->dropForeign('supplier_bill_items_supplier_bill_id_foreign');
		});
		Schema::table('product_materials', function(Blueprint $table) {
			$table->dropForeign('product_materials_product_id_foreign');
		});
		Schema::table('product_materials', function(Blueprint $table) {
			$table->dropForeign('product_materials_material_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_group_id_foreign');
		});
		Schema::table('technical_proposals', function(Blueprint $table) {
			$table->dropForeign('technical_proposals_client_id_foreign');
		});
		Schema::table('proposal_items', function(Blueprint $table) {
			$table->dropForeign('proposal_items_technical_proposal_id_foreign');
		});
		Schema::table('proposal_items', function(Blueprint $table) {
			$table->dropForeign('proposal_items_product_id_foreign');
		});
		Schema::table('commercial_proposal', function(Blueprint $table) {
			$table->dropForeign('commercial_proposal_technical_proposal_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_commercial_proposal_id_foreign');
		});
	}
}