<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShiftsTable extends Migration {

	public function up()
	{
		Schema::create('shifts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 127);
			$table->date('requested_date');
			$table->time('requested_time');
			$table->date('proposed_date');
			$table->time('proposed_time');
			$table->text('address');
			$table->tinyInteger('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('shifts');
	}
}