<?php

namespace Device;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Device extends Model 
{

    protected $table = 'Device';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function restaurnat()
    {
        return $this->belongsTo('Restaurant');
    }

    public function employee()
    {
        return $this->belongsTo('Employee');
    }

    public function instances()
    {
        return $this->hasMany('Instance_Device');
    }

}