<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDomainsSubdomainsTable extends Migration {

	public function up()
	{
		Schema::create('domains_subdomains', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('domain_id')->unsigned();
			$table->integer('database_server_id')->unsigned();
			$table->integer('web_server_id')->unsigned();
			$table->string('name', 255)->index();
			$table->text('nginx_config');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('domains_subdomains');
	}
}