<?php

namespace PWCSD\NemesiCMS\Admin\Projects\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectBranch extends Eloquent {

	protected $table = 'projects_branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function commits()
	{
		return $this->hasMany('ProjectBranchCommit', 'project_branch_id');
	}

	public function database()
	{
		return $this->hasOne('ProjectDatabase', 'project_database_id');
	}

}