<?php

namespace PWCSD\NemesiCMS\Admin\Projects\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function branches()
	{
		return $this->hasMany('ProjectBranch', 'project_id');
	}

	public function commits()
	{
		return $this->hasManyThrough('ProjectBranch', 'ProjectBranchCommit', 'project_id', 'project_branch_id');
	}

	public function users()
	{
		return $this->belongsToMany('User');
	}

	public function releases()
	{
		return $this->hasMany('ProjectRelease', 'project_id');
	}

	public function databases()
	{
		return $this->hasMany('ProjectDatabase', 'project_id');
	}

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

}