<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostTable extends Migration {

	public function up()
	{
		Schema::create('post', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned()->nullable();
			$table->string('title');
			$table->string('slug')->index();
			$table->mediumText('synopsis')->nullable();
			$table->string('description');
			$table->string('image')->nullable();
			$table->enum('status', array('ACTIVE', 'DRAFT'));
			$table->datetime('published_at');
			$table->timestamps();
			$table->softDeletes();
			$table->string('meta_title')->nullable();
			$table->string('meta_description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('post');
	}
}