<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingTable extends Migration {

	public function up()
	{
		Schema::create('setting', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('site_title')->nullable();
			$table->string('site_description')->nullable();
			$table->string('homepage_title')->nullable();
			$table->string('facebook_app_id')->nullable();
			$table->string('facebook_app_secret')->nullable();
			$table->tinyInteger('is_static')->index()->default('1');
			$table->string('google_analytics_id')->nullable();
			$table->text('script_head')->nullable();
			$table->text('script_body_start')->nullable();
			$table->text('script_body_end')->nullable();
			$table->string('logo')->nullable();
			$table->string('favicon')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('setting');
	}
}