<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('image', 'name', 'mobile', 'address', 'password', 'login_type', 'social_id', 'notifiystatus');

	public function addresses()
	{
		return $this->hasMany('App\Models\Address');
	}

	public function tokens()
	{
		return $this->hasMany('App\Models\Token');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

	public function messages()
	{
		return $this->hasMany('App\Models\Message');
	}

	public function conversations()
	{
		return $this->hasMany('App\Models\Conversation');
	}

	public function rates()
	{
		return $this->hasMany('App\Models\Rate');
	}

	public function trips()
	{
		return $this->hasMany('App\Models\Trip');
	}

}