<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function payment()
	{
		return $this->hasMany('\Payment');
	}

	public function orders()
	{
		return $this->belongsToMany('\Order', 'order_id');
	}

	public function subscriptions()
	{
		return $this->hasMany('\Subscription');
	}

}