<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_size', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_size', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->foreign('color_product_id')->references('id')->on('color_product')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->foreign('picture_id')->references('id')->on('pictures')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('attribute_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('attribute_product', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combos', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->foreign('combo_id')->references('id')->on('combos')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->foreign('combo_item_id')->references('id')->on('combo_items')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->foreign('classification_id')->references('id')->on('menu_classifications')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('trademark_products', function(Blueprint $table) {
			$table->foreign('trademark_id')->references('id')->on('trademarks')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('trademark_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('ingredients', function(Blueprint $table) {
			$table->foreign('measuring_unit_id')->references('id')->on('measuring_units')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('code_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('code_product', function(Blueprint $table) {
			$table->foreign('code_id')->references('id')->on('codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_types', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_types', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->foreign('inventory_id')->references('id')->on('inventory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->foreign('branch_inventory_id')->references('id')->on('branch_inventory')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->foreign('ingredient_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_stock', function(Blueprint $table) {
			$table->foreign('stock_id')->references('id')->on('stocks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_stock', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_stock_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_stock_products', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_stock_products', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->foreign('product_size_id')->references('id')->on('product_size')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->foreign('color_product_id')->references('id')->on('color_product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->foreign('branch_category_id')->references('id')->on('branch_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cashiers', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('no action')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('product_size', function(Blueprint $table) {
			$table->dropForeign('product_size_product_id_foreign');
		});
		Schema::table('product_size', function(Blueprint $table) {
			$table->dropForeign('product_size_size_id_foreign');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->dropForeign('color_product_product_id_foreign');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->dropForeign('color_product_product_size_id_foreign');
		});
		Schema::table('color_product', function(Blueprint $table) {
			$table->dropForeign('color_product_color_id_foreign');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->dropForeign('product_pictures_product_id_foreign');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->dropForeign('product_pictures_color_product_id_foreign');
		});
		Schema::table('product_pictures', function(Blueprint $table) {
			$table->dropForeign('product_pictures_picture_id_foreign');
		});
		Schema::table('attribute_product', function(Blueprint $table) {
			$table->dropForeign('attribute_product_product_id_foreign');
		});
		Schema::table('attribute_product', function(Blueprint $table) {
			$table->dropForeign('attribute_product_attribute_id_foreign');
		});
		Schema::table('combos', function(Blueprint $table) {
			$table->dropForeign('combos_size_id_foreign');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->dropForeign('combo_items_combo_id_foreign');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->dropForeign('combo_items_product_id_foreign');
		});
		Schema::table('combo_items', function(Blueprint $table) {
			$table->dropForeign('combo_items_product_size_id_foreign');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->dropForeign('combo_Item_options_combo_item_id_foreign');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->dropForeign('combo_Item_options_product_id_foreign');
		});
		Schema::table('combo_Item_options', function(Blueprint $table) {
			$table->dropForeign('combo_Item_options_product_size_id_foreign');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->dropForeign('menu_classification_products_classification_id_foreign');
		});
		Schema::table('menu_classification_products', function(Blueprint $table) {
			$table->dropForeign('menu_classification_products_product_id_foreign');
		});
		Schema::table('trademark_products', function(Blueprint $table) {
			$table->dropForeign('trademark_products_trademark_id_foreign');
		});
		Schema::table('trademark_products', function(Blueprint $table) {
			$table->dropForeign('trademark_products_product_id_foreign');
		});
		Schema::table('ingredients', function(Blueprint $table) {
			$table->dropForeign('ingredients_measuring_unit_id_foreign');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->dropForeign('product_size_ingredients_product_size_id_foreign');
		});
		Schema::table('product_size_ingredients', function(Blueprint $table) {
			$table->dropForeign('product_size_ingredients_ingredient_id_foreign');
		});
		Schema::table('code_product', function(Blueprint $table) {
			$table->dropForeign('code_product_product_id_foreign');
		});
		Schema::table('code_product', function(Blueprint $table) {
			$table->dropForeign('code_product_code_id_foreign');
		});
		Schema::table('product_types', function(Blueprint $table) {
			$table->dropForeign('product_types_product_id_foreign');
		});
		Schema::table('product_types', function(Blueprint $table) {
			$table->dropForeign('product_types_type_id_foreign');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_inventory_id_foreign');
		});
		Schema::table('branch_inventory', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_branch_id_foreign');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_ingredients_branch_inventory_id_foreign');
		});
		Schema::table('branch_inventory_ingredients', function(Blueprint $table) {
			$table->dropForeign('branch_inventory_ingredients_ingredient_id_foreign');
		});
		Schema::table('branch_stock', function(Blueprint $table) {
			$table->dropForeign('branch_stock_stock_id_foreign');
		});
		Schema::table('branch_stock', function(Blueprint $table) {
			$table->dropForeign('branch_stock_branch_id_foreign');
		});
		Schema::table('branch_stock_products', function(Blueprint $table) {
			$table->dropForeign('branch_stock_products_product_id_foreign');
		});
		Schema::table('branch_stock_products', function(Blueprint $table) {
			$table->dropForeign('branch_stock_products_size_id_foreign');
		});
		Schema::table('branch_stock_products', function(Blueprint $table) {
			$table->dropForeign('branch_stock_products_color_id_foreign');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->dropForeign('product_prices_product_id_foreign');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->dropForeign('product_prices_product_size_id_foreign');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->dropForeign('product_prices_color_product_id_foreign');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->dropForeign('branch_categories_branch_id_foreign');
		});
		Schema::table('branch_categories', function(Blueprint $table) {
			$table->dropForeign('branch_categories_category_id_foreign');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->dropForeign('branch_category_products_branch_category_id_foreign');
		});
		Schema::table('branch_category_products', function(Blueprint $table) {
			$table->dropForeign('branch_category_products_product_id_foreign');
		});
		Schema::table('cashiers', function(Blueprint $table) {
			$table->dropForeign('cashiers_branch_id_foreign');
		});
	}
}