<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BranchStockProducts extends Eloquent {

	protected $table = 'branch_stock_products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('Product');
	}

	public function size()
	{
		return $this->belongsTo('Size');
	}

	public function color()
	{
		return $this->belongsTo('Color');
	}

}