<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ComboItems extends Eloquent {

	protected $table = 'combo_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->belongsTo('Product');
	}

	public function comboItemOption()
	{
		return $this->hasMany('ComboItemOption');
	}

	public function productSize()
	{
		return $this->belongsTo('ProductSize');
	}

}