<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function size()
	{
		return $this->belongsToMany('Size');
	}

	public function color()
	{
		return $this->belongsToMany('Color');
	}

	public function picture()
	{
		return $this->hasMany('ProductPicture');
	}

	public function attribute()
	{
		return $this->belongsToMany('Attribute');
	}

}