<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductPricesTable extends Migration {

	public function up()
	{
		Schema::create('product_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned()->index();
			$table->bigInteger('product_size_id')->unsigned()->nullable()->index();
			$table->bigInteger('color_product_id')->unsigned()->nullable()->index();
			$table->double('price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product_prices');
	}
}