<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->decimal('price', 12,4);
			$table->float('discount')->nullable();
			$table->integer('category_id');
			$table->longText('overview')->nullable();
			$table->string('size')->nullable();
			$table->string('dimension');
			$table->string('box_dimension');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}