<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDonationRequestsTable extends Migration {

	public function up()
	{
		Schema::create('donation_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->smallInteger('age');
			$table->integer('blood_type_id')->unsigned()->index();
			$table->smallInteger('num_of_bags');
			$table->decimal('latitudes');
			$table->decimal('longitude');
			$table->integer('governorate_id')->unsigned()->index();
			$table->integer('phone');
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('donation_requests');
	}
}