<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePhonesTable extends Migration {

	public function up()
	{
		Schema::create('phones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('brand');
			$table->integer('series');
			$table->text('model')->nullable();
			$table->text('year')->nullable();
			$table->text('description')->nullable();
			$table->text('image');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('phones');
	}
}