<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Phone extends Eloquent {

	protected $table = 'phones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function brand()
	{
		return $this->hasOne('App\Models\Brand', 'id');
	}

	public function phoneseries()
	{
		return $this->hasOne('App\Models\BrandSeries', 'id');
	}

}