<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('timestamps', 'email', 'neighborhood_id', 'password', 'pin_code');

	public function resturant()
	{
		return $this->belongsTo('App\Models\Resturant');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function neighborhood()
	{
		return $this->belongsTo('App\Models\Neighborhood');
	}

	public function review()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function notifications()
	{
		return $this->morphMany('App\Models\Notification');
	}

	public function tokens()
	{
		return $this->morphMany('App\Models\Token');
	}

}