<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealsTable extends Migration {

	public function up()
	{
		Schema::create('meals', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->double('price');
			$table->text('description');
			$table->string('image')->nullable();
			$table->double('price_in_offer')->nullable();
			$table->tinyInteger('is_offer')->default('0,1');
		});
	}

	public function down()
	{
		Schema::drop('meals');
	}
}