<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->text('note');
			$table->double('price');
			$table->double('total_price');
			$table->string('payment_method');
			$table->double('delivery_fees');
			$table->string('address');
			$table->enum('status', array(''pending'', ''accept'', ''decline'', ''rejected', '''));
			$table->integer('resturant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}