<?php

namespace App\Model;

class Attendance extends Eloquent {

	protected $table = 'm_attendance';
	public $timestamps = true;
	protected $fillable = array('pernr', 'personnel_area', 'personnel_subarea', 'org_unit', 'date', 'time', 'type', 'description', 'is_active', 'is_backlog', 'range', 'created_by', 'updated_by', 'latitude', 'file_id', 'longitude', 'approved', 'in_range', 'is_correction', 'last_id');

	public function approval()
	{
		return $this->hasMany('App\Model\AttendanceApproval', 'attendance_id');
	}

	public function files()
	{
		return $this->belongsTo('App\Model\Files', 'file_id');
	}

	public function getType()
	{
		return $this->belongsTo('App\Model\AttendanceType', 'type');
	}

	public function lastID()
	{
		return $this->belongsTo('App\Model\Attendance', 'last_id');
	}

}