<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('type')->unsigned()->default('0');
			$table->tinyInteger('auto_push')->unsigned()->default('0');
			$table->datetime('enable_date');
			$table->datetime('disable_date');
			$table->string('title', 100);
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}