<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePushsTable extends Migration {

	public function up()
	{
		Schema::create('pushs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 500);
			$table->string('sub_title', 500);
			$table->datetime('enable_date');
			$table->datetime('disable_date');
			$table->tinyInteger('status')->default('0');
			$table->string('url', 500);
		});
	}

	public function down()
	{
		Schema::drop('pushs');
	}
}