<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyTable extends Migration {

	public function up()
	{
		Schema::create('property', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title');
			$table->string('subtitle')->nullable();
			$table->longText('description');
			$table->enum('type', array('apartment', 'House'));
			$table->string('rooms');
			$table->string('bathrooms');
			$table->string('floor_number');
			$table->string('guard');
			$table->enum('status', array('active', 'inactive'));
			$table->string('kitchen');
			$table->string('Lift');
			$table->string('Interior_view');
			$table->string('Balcony');
			$table->string('Parking');
			$table->string('Children_area');
			$table->string('gym');
			$table->string('communal_living');
			$table->string('closed_set');
			$table->string('size');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('property');
	}
}