<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Website extends Model 
{

    protected $table = 'websites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function languages()
    {
        return $this->belongsToMany('Language')->withPivot('default');
    }

    public function sitemaps()
    {
        return $this->hasMany('Sitemap');
    }

}