<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUrlsTable extends Migration {

	public function up()
	{
		Schema::create('urls', function(Blueprint $table) {
			$table->increments('id');
			$table->string('url');
			$table->string('model_type');
			$table->integer('model_id')->index();
			$table->enum('type', array('original', 'redirect'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('urls');
	}
}