<?php

namespace Mediapress/Core/Models;

class PageDetail extends Eloquent {

	protected $table = 'page_details';
	public $timestamps = false;

	public function pages()
	{
		return $this->belongsTo('Page');
	}

	public function extras()
	{
		return $this->hasMany('PageDetailExtra');
	}

	public function language()
	{
		return $this->belongsTo('Language');
	}

	public function url()
	{
		return $this->morphOne('Url', 'model')->where('type','original');
	}

}