<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Property extends Eloquent {

	protected $table = 'properties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function details()
	{
		return $this->hasMany('PropertyDetail');
	}

	public function sitemap()
	{
		return $this->belongsTo('Sitemap');
	}

}