<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sitemap extends Eloquent {

	protected $table = 'sitemaps';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function details()
	{
		return $this->hasMany('SitemapDetail');
	}

	public function categories()
	{
		return $this->hasMany('Category');
	}

	public function module()
	{
		return $this->belongsTo('Module');
	}

	public function website()
	{
		return $this->belongsTo('Website');
	}

}