<?php

namespace Mediapress/Core/Models;

use Illuminate\Database\Eloquent\Model;

class SitemapDetail extends Model 
{

    protected $table = 'sitemap_details';
    public $timestamps = false;

    public function url()
    {
        return $this->morphOne('Url', 'model')->where('type','original');
    }

    public function extras()
    {
        return $this->morphMany('Extra', 'model');
    }

    public function sitemap()
    {
        return $this->belongsTo('Sitemap');
    }

    public function language()
    {
        return $this->belongsTo('Language');
    }

}