<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCityTable extends Migration {

	public function up()
	{
		Schema::create('city', function(Blueprint $table) {
			$table->increments('city_code')->primary();
			$table->string('city', 255)->index();
			$table->string('muncipality', 255)->index();
			$table->string('muncipality_code')->index();
			$table->string('province', 255);
			$table->string('province_code');
			$table->boolean('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('city');
	}
}