<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'active');
    protected $visible = array('title', 'active');

    public function Users()
    {
        return $this->hasMany('User', 'groupid', 'id');
    }

}