<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'active');
	protected $visible = array('title', 'active');

	public function Users()
	{
		return $this->hasMany('User', 'groupid', 'id');
	}

}